# ADOBE CONFIDENTIAL
#
# Copyright 2010-2022 Adobe
# All Rights Reserved.
#
# NOTICE:  Adobe permits you to use, modify, and distribute this file in
# accordance with the terms of the Adobe license agreement accompanying it.
# If you have received this file from a source other than Adobe,
# then your use, modification, or distribution of it requires the prior
# written permission of Adobe.
#
# Autogenerated by ipa. Don't edit directly, edit the definitions and regenerate it when changing
#

from __future__ import annotations

import ctypes
import base64

from typing import Any, Optional

from .sdarray import *
from .sdvaluestring import *
from .sdapiobject import *
from .sdbasetypes import *
from .sdapiobject import *
from .apiexception import APIException

class SDColorManagementEngine(SDAPIObject):
    """
    Color management engine. There is only one SDColorManagementEngine, that you can retrieve from the SDApplication
    """
    def __init__(self, APIContext, handle, *args, **kwargs):
        """
        Constructor

        :rtype: SDColorManagementEngine
        """
        super(SDColorManagementEngine, self).__init__(APIContext, handle, *args, **kwargs)

    def getName(self) -> str:
        """
        Get the color management engine name

        """
        outValue = ctypes.c_char_p()
        _res = self.mAPIContext.SDColorManagementEngine_getName(self.mHandle, ctypes.byref(outValue))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outValue.value.decode('utf-8') # type: ignore

    def getWorkingColorSpaceName(self) -> str:
        """
        Get the working color space name

        """
        outValue = ctypes.c_char_p()
        _res = self.mAPIContext.SDColorManagementEngine_getWorkingColorSpaceName(self.mHandle, ctypes.byref(outValue))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outValue.value.decode('utf-8') # type: ignore

    def getRawColorSpaceName(self) -> str:
        """
        Get the raw color space name

        """
        outValue = ctypes.c_char_p()
        _res = self.mAPIContext.SDColorManagementEngine_getRawColorSpaceName(self.mHandle, ctypes.byref(outValue))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outValue.value.decode('utf-8') # type: ignore

    def getColorSpaces(self) -> Optional[SDArray[SDValueString]]:
        """
        Get the list of color space names.

        """
        outColorSpaceArray = ctypes.c_void_p()
        _res = self.mAPIContext.SDColorManagementEngine_getColorSpaces(self.mHandle, ctypes.byref(outColorSpaceArray))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        constructor = self.mAPIContext.mTypeMap[SDAPIObject(self.mAPIContext, outColorSpaceArray, ownHandle=False).getClassName()]
        return constructor(self.mAPIContext, outColorSpaceArray.value, ownHandle=True)

    def getOCIOConfigFileName(self) -> Optional[str]:
        """
        Get the filename of the current OCIO configuration or None, if not using OpenColorIO

        """
        outValue = ctypes.c_char_p()
        _res = self.mAPIContext.SDColorManagementEngine_getOCIOConfigFileName(self.mHandle, ctypes.byref(outValue))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outValue.value.decode('utf-8') # type: ignore

    def convertWorkingColorSpaceToDisplayColorSpace(self, inValue : ColorRGB) -> ColorRGB:
        """
        Convert a ColorRGB from the working color space to the display color space

        :param inValue: The input color
        """
        outValue = ColorRGB()
        _res = self.mAPIContext.SDColorManagementEngine_convertWorkingColorSpaceToDisplayColorSpace(self.mHandle, ctypes.byref(inValue), ctypes.byref(outValue))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outValue

    def canConvertLabColorToWorkingColorSpace(self) -> bool:
        """
        Indicates if the color management engine can convert Lab colors to the working color space

        """
        outValue = ctypes.c_bool()
        _res = self.mAPIContext.SDColorManagementEngine_canConvertLabColorToWorkingColorSpace(self.mHandle, ctypes.byref(outValue))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outValue.value

    def convertLabColorSpaceToWorkingColorSpace(self, inValue : ColorRGB) -> ColorRGB:
        """
        Convert a ColorRGB from the working color space to the display color space

        :param inValue: The input color
        """
        outValue = ColorRGB()
        _res = self.mAPIContext.SDColorManagementEngine_convertLabColorSpaceToWorkingColorSpace(self.mHandle, ctypes.byref(inValue), ctypes.byref(outValue))
        if _res != SDApiError.NoError.value:
            if _res == SDApiError.NoErrorOutputParamNotSet.value:
                return None # type: ignore
            raise APIException(SDApiError(_res))
        return outValue

